package com.ejie.aa17a.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aBandaDao;
import com.ejie.aa17a.model.Aa17aBanda;
import com.ejie.aa17a.utilidades.Aa17aConstantes;

/**
 * Aa17aBandaDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aBandaDaoImpl implements Aa17aBandaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aa17aBanda> rwMap = new RowMapper<Aa17aBanda>() {
		public Aa17aBanda mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Locale locale = LocaleContextHolder.getLocale();
			Aa17aBanda banda = new Aa17aBanda();

			banda.setIdBanda(resultSet.getLong("IDBANDA"));
			banda.setDescripcionCastellano(resultSet.getString("DESCRIPCIONCASTELLANO"));
			banda.setDescripcionEuskera(resultSet.getString("DESCRIPCIONEUSKERA"));
			banda.setColorBanda(resultSet.getString("COLORBANDA"));

			if (resultSet.getTimestamp("FECHABAJA") != null) {
				banda.setFechaBaja(new Date(resultSet.getTimestamp("FECHABAJA").getTime()));
			}

			banda.setIcono(resultSet.getString("ICONO"));

			if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
				banda.setDescripcion(resultSet.getString("DESCRIPCIONEUSKERA"));
			}
			else {
				banda.setDescripcion(resultSet.getString("DESCRIPCIONCASTELLANO"));
			}

			return banda;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the Aa17aBanda table.
	 * 
	 * @param aa17abanda
	 *            Pagination
	 * @return Aa17aBanda
	 */
	@Transactional(readOnly = true)
	public Aa17aBanda find(Aa17aBanda aa17abanda) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t1.T04_BANDA_ID IDBANDA, ");
		query.append(" t1.T04_DESC_ES DESCRIPCIONCASTELLANO, t1.T04_DESC_EU DESCRIPCIONEUSKERA, ");
		query.append(" t1.T04_COLOR COLORBANDA, t1.T04_FECHA_BAJA FECHABAJA, ");
		query.append(" t1.T04_ICONO ICONO ");
		query.append(" FROM AA1704S00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17abanda);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (Aa17aBanda) DataAccessUtils.uniqueResult(this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray()));
	}

	/**
	 * Finds a List of rows in the Aa17aBanda table.
	 * 
	 * @param aa17abanda
	 *            Aa17aBanda
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aBanda> findAll(Aa17aBanda aa17abanda) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t1.T04_BANDA_ID IDBANDA, ");
		query.append(" t1.T04_DESC_ES DESCRIPCIONCASTELLANO, t1.T04_DESC_EU DESCRIPCIONEUSKERA, ");
		query.append(" t1.T04_COLOR COLORBANDA, t1.T04_FECHA_BAJA FECHABAJA, ");
		query.append(" t1.T04_ICONO ICONO ");
		query.append(" FROM AA1704S00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17abanda);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY IDBANDA");

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Aa17aBanda>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aBanda entity
	 * 
	 * @param aa17abanda
	 *            Aa17aBanda Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa17aBanda aa17abanda) {

		StringBuffer where = new StringBuffer(Aa17aBandaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17abanda != null && aa17abanda.getIdBanda() != null) {
			where.append(" AND t1.T04_BANDA_ID = ?");
			params.add(aa17abanda.getIdBanda());
		}

		if (aa17abanda != null && aa17abanda.getEstado() != null & aa17abanda.getEstado() == Aa17aConstantes.ESTADO_ACTIVO) {
			where.append(" AND t1.T04_FECHA_BAJA IS NULL "); //Que no este dado de baja
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
